/*
 * Decompiled with CFR 0.152.
 */
package com.advantageplay.tictactoe;

import com.advantageplay.tictactoe.DifficultyButton;
import com.advantageplay.tictactoe.GameTile;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;
import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class TicTacToe
extends Application {
    private final GameTile[] gameTiles = new GameTile[9];
    private final Label drawLabel = new Label("It's a draw.");
    private final Label loseLabel = new Label("You lose...");
    private final Label winLabel = new Label("You win!");
    private final Random random = new Random();
    private boolean isAIWin = false;
    private boolean isDraw = false;
    private boolean isPlayerFirst = true;
    private boolean isPlayerWin = false;
    private HBox mainHBox;
    private int currentTurn = 1;
    private int difficulty = 0;
    private int totalDraws = 0;
    private int totalLosses = 0;
    private int totalWins = 0;
    private Label totalDrawsLabel;
    private Label totalLossesLabel;
    private Label totalWinsLabel;
    private StackPane root;

    @Override
    public void start(Stage stage) {
        ImageView backgroundImageView = new ImageView(new Image(Objects.requireNonNull(TicTacToe.class.getResource("images/WoodBackground.png")).toString()));
        backgroundImageView.setFitWidth(1000.0);
        backgroundImageView.setPreserveRatio(true);
        ImageView difficultyMenuImageView = new ImageView(new Image(Objects.requireNonNull(TicTacToe.class.getResource("images/DifficultyMenu.png")).toString()));
        difficultyMenuImageView.setFitWidth(400.0);
        difficultyMenuImageView.setPreserveRatio(true);
        DifficultyButton easyButton = new DifficultyButton(Objects.requireNonNull(TicTacToe.class.getResource("images/Easy.png")).toString());
        DifficultyButton mediumButton = new DifficultyButton(Objects.requireNonNull(TicTacToe.class.getResource("images/Medium.png")).toString());
        DifficultyButton hardButton = new DifficultyButton(Objects.requireNonNull(TicTacToe.class.getResource("images/Hard.png")).toString());
        VBox difficultyVBox = new VBox(easyButton, mediumButton, hardButton);
        difficultyVBox.setAlignment(Pos.CENTER);
        difficultyVBox.setTranslateY(50.0);
        difficultyVBox.setSpacing(5.0);
        StackPane difficultyStackPane = new StackPane(difficultyMenuImageView, difficultyVBox);
        ImageView notebookImageView = new ImageView(new Image(Objects.requireNonNull(TicTacToe.class.getResource("images/Notebook.png")).toString()));
        notebookImageView.setFitHeight(550.0);
        notebookImageView.setFitWidth(425.0);
        notebookImageView.setTranslateX(-10.0);
        for (int i = 0; i < this.gameTiles.length; ++i) {
            this.gameTiles[i] = new GameTile();
        }
        GridPane boardGridPane = new GridPane();
        int currentTile = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                boardGridPane.add(this.gameTiles[currentTile], j, i);
                ++currentTile;
            }
        }
        boardGridPane.setAlignment(Pos.CENTER);
        StackPane boardPane = new StackPane(notebookImageView, boardGridPane);
        boardGridPane.setTranslateY(40.0);
        boardGridPane.setTranslateX(-7.0);
        this.winLabel.getStyleClass().add("win-text");
        this.winLabel.setVisible(false);
        this.loseLabel.getStyleClass().add("lose-text");
        this.loseLabel.setVisible(false);
        this.drawLabel.getStyleClass().add("draw-text");
        this.drawLabel.setVisible(false);
        StackPane resultStackPane = new StackPane(this.winLabel, this.loseLabel, this.drawLabel);
        ImageView postitImageView = new ImageView(new Image(Objects.requireNonNull(TicTacToe.class.getResource("images/Postit.png")).toString()));
        postitImageView.setFitWidth(250.0);
        postitImageView.setPreserveRatio(true);
        Label wLabel = new Label("W - ");
        wLabel.getStyleClass().add("results-text");
        this.totalWinsLabel = new Label(Integer.toString(this.totalWins));
        this.totalWinsLabel.getStyleClass().add("results-text");
        HBox winsHBox = new HBox(wLabel, this.totalWinsLabel);
        winsHBox.setAlignment(Pos.CENTER);
        Label lLabel = new Label("L - ");
        lLabel.getStyleClass().add("results-text");
        this.totalLossesLabel = new Label(Integer.toString(this.totalLosses));
        this.totalLossesLabel.getStyleClass().add("results-text");
        HBox lossesHBox = new HBox(lLabel, this.totalLossesLabel);
        lossesHBox.setAlignment(Pos.CENTER);
        Label dLabel = new Label("D - ");
        dLabel.getStyleClass().add("results-text");
        this.totalDrawsLabel = new Label(Integer.toString(this.totalDraws));
        this.totalDrawsLabel.getStyleClass().add("results-text");
        HBox drawsHBox = new HBox(dLabel, this.totalDrawsLabel);
        drawsHBox.setAlignment(Pos.CENTER);
        VBox postitVBox = new VBox(winsHBox, lossesHBox, drawsHBox);
        postitVBox.setAlignment(Pos.CENTER);
        StackPane postitStackPane = new StackPane(postitImageView, postitVBox);
        Button newGameButton = new Button("New Game");
        newGameButton.getStyleClass().add("new-game-button");
        VBox toolbarVBox = new VBox(resultStackPane, postitStackPane, newGameButton);
        toolbarVBox.setSpacing(20.0);
        toolbarVBox.setAlignment(Pos.CENTER);
        this.mainHBox = new HBox(boardPane, toolbarVBox);
        this.mainHBox.setAlignment(Pos.CENTER);
        this.mainHBox.setSpacing(100.0);
        this.root = new StackPane(backgroundImageView, difficultyStackPane);
        Scene scene = new Scene(this.root, 1000.0, 700.0);
        scene.getStylesheets().add(Objects.requireNonNull(TicTacToe.class.getResource("TicTacToe.css")).toString());
        stage.setTitle("Tic-Tac-Toe");
        stage.setResizable(false);
        stage.setScene(scene);
        stage.show();
        easyButton.getButton().setOnAction(event -> this.setDifficulty(0));
        mediumButton.getButton().setOnAction(event -> this.setDifficulty(1));
        hardButton.getButton().setOnAction(event -> this.setDifficulty(2));
        this.gameTiles[0].getButton().setOnAction(event -> this.playerTurn(0));
        this.gameTiles[1].getButton().setOnAction(event -> this.playerTurn(1));
        this.gameTiles[2].getButton().setOnAction(event -> this.playerTurn(2));
        this.gameTiles[3].getButton().setOnAction(event -> this.playerTurn(3));
        this.gameTiles[4].getButton().setOnAction(event -> this.playerTurn(4));
        this.gameTiles[5].getButton().setOnAction(event -> this.playerTurn(5));
        this.gameTiles[6].getButton().setOnAction(event -> this.playerTurn(6));
        this.gameTiles[7].getButton().setOnAction(event -> this.playerTurn(7));
        this.gameTiles[8].getButton().setOnAction(event -> this.playerTurn(8));
        newGameButton.setOnAction(event -> {
            this.isDraw = false;
            this.isAIWin = false;
            this.isPlayerWin = false;
            this.currentTurn = 1;
            for (GameTile gameTile : this.gameTiles) {
                gameTile.reset();
            }
            this.winLabel.setVisible(false);
            this.loseLabel.setVisible(false);
            this.drawLabel.setVisible(false);
            if (this.isPlayerFirst) {
                this.isPlayerFirst = false;
                this.aiTurn();
            } else {
                this.isPlayerFirst = true;
            }
        });
    }

    private void aiTurn() {
        int bestScore = -99;
        LinkedList<Integer> bestChoices = new LinkedList<Integer>();
        if (this.difficulty == 0) {
            int aiChoice = this.random.nextInt(this.gameTiles.length);
            if (!this.gameTiles[aiChoice].isPlayer() && !this.gameTiles[aiChoice].isAI()) {
                this.gameTiles[aiChoice].select(false);
                this.evaluateTurn();
            } else {
                this.aiTurn();
            }
        } else {
            if (this.difficulty == 2 && this.currentTurn <= 2 && !this.gameTiles[4].isAI() && !this.gameTiles[4].isPlayer()) {
                this.gameTiles[4].select(false);
            } else {
                for (int i = 0; i < this.gameTiles.length; ++i) {
                    int miniMaxScore;
                    if (this.gameTiles[i].isPlayer() || this.gameTiles[i].isAI() || (miniMaxScore = this.miniMax(true, this.gameTiles, i, this.currentTurn, 0)) < bestScore) continue;
                    if (miniMaxScore != bestScore) {
                        bestChoices.clear();
                        bestScore = miniMaxScore;
                    }
                    bestChoices.add(i);
                }
                int aiChoice = (Integer)bestChoices.get(this.random.nextInt(bestChoices.size()));
                this.gameTiles[aiChoice].select(false);
            }
            this.evaluateTurn();
        }
    }

    private void endGame() {
        for (GameTile gameTile : this.gameTiles) {
            gameTile.getButton().setDisable(true);
        }
        if (this.isDraw) {
            ++this.totalDraws;
            this.totalDrawsLabel.setText(Integer.toString(this.totalDraws));
            this.drawLabel.setVisible(true);
        } else if (this.isAIWin) {
            ++this.totalLosses;
            this.totalLossesLabel.setText(Integer.toString(this.totalLosses));
            this.loseLabel.setVisible(true);
        } else if (this.isPlayerWin) {
            ++this.totalWins;
            this.totalWinsLabel.setText(Integer.toString(this.totalWins));
            this.winLabel.setVisible(true);
        }
    }

    private void evaluateTurn() {
        if (this.gameTiles[0].isAI() && this.gameTiles[1].isAI() && this.gameTiles[2].isAI()) {
            this.isAIWin = true;
        } else if (this.gameTiles[0].isAI() && this.gameTiles[4].isAI() && this.gameTiles[8].isAI()) {
            this.isAIWin = true;
        } else if (this.gameTiles[0].isAI() && this.gameTiles[3].isAI() && this.gameTiles[6].isAI()) {
            this.isAIWin = true;
        } else if (this.gameTiles[8].isAI() && this.gameTiles[5].isAI() && this.gameTiles[2].isAI()) {
            this.isAIWin = true;
        } else if (this.gameTiles[8].isAI() && this.gameTiles[7].isAI() && this.gameTiles[6].isAI()) {
            this.isAIWin = true;
        } else if (this.gameTiles[2].isAI() && this.gameTiles[4].isAI() && this.gameTiles[6].isAI()) {
            this.isAIWin = true;
        } else if (this.gameTiles[1].isAI() && this.gameTiles[4].isAI() && this.gameTiles[7].isAI()) {
            this.isAIWin = true;
        } else if (this.gameTiles[3].isAI() && this.gameTiles[4].isAI() && this.gameTiles[5].isAI()) {
            this.isAIWin = true;
        } else if (this.gameTiles[0].isPlayer() && this.gameTiles[1].isPlayer() && this.gameTiles[2].isPlayer()) {
            this.isPlayerWin = true;
        } else if (this.gameTiles[0].isPlayer() && this.gameTiles[4].isPlayer() && this.gameTiles[8].isPlayer()) {
            this.isPlayerWin = true;
        } else if (this.gameTiles[0].isPlayer() && this.gameTiles[3].isPlayer() && this.gameTiles[6].isPlayer()) {
            this.isPlayerWin = true;
        } else if (this.gameTiles[8].isPlayer() && this.gameTiles[5].isPlayer() && this.gameTiles[2].isPlayer()) {
            this.isPlayerWin = true;
        } else if (this.gameTiles[8].isPlayer() && this.gameTiles[7].isPlayer() && this.gameTiles[6].isPlayer()) {
            this.isPlayerWin = true;
        } else if (this.gameTiles[2].isPlayer() && this.gameTiles[4].isPlayer() && this.gameTiles[6].isPlayer()) {
            this.isPlayerWin = true;
        } else if (this.gameTiles[1].isPlayer() && this.gameTiles[4].isPlayer() && this.gameTiles[7].isPlayer()) {
            this.isPlayerWin = true;
        } else if (this.gameTiles[3].isPlayer() && this.gameTiles[4].isPlayer() && this.gameTiles[5].isPlayer()) {
            this.isPlayerWin = true;
        }
        ++this.currentTurn;
        if (this.currentTurn == 10 && !this.isPlayerWin && !this.isAIWin) {
            this.isDraw = true;
        }
        if (this.isAIWin || this.isPlayerWin || this.isDraw) {
            this.endGame();
        }
    }

    private int miniMax(boolean isMaximizing, GameTile[] tiles, int currentTile, int cTurn, int simRound) {
        int bestScore;
        int i;
        GameTile[] gTiles = new GameTile[9];
        boolean isMiniMaxAIWin = false;
        boolean isMiniMaxPlayerWin = false;
        boolean isMiniMaxDraw = false;
        int totalFreeTiles = 0;
        for (i = 0; i < gTiles.length; ++i) {
            gTiles[i] = new GameTile();
            if (tiles[i].isAI()) {
                gTiles[i].select(false);
                continue;
            }
            if (tiles[i].isPlayer()) {
                gTiles[i].select(true);
                continue;
            }
            ++totalFreeTiles;
        }
        gTiles[currentTile].select(!isMaximizing);
        if (gTiles[0].isAI() && gTiles[1].isAI() && gTiles[2].isAI()) {
            isMiniMaxAIWin = true;
        } else if (gTiles[0].isAI() && gTiles[4].isAI() && gTiles[8].isAI()) {
            isMiniMaxAIWin = true;
        } else if (gTiles[0].isAI() && gTiles[3].isAI() && gTiles[6].isAI()) {
            isMiniMaxAIWin = true;
        } else if (gTiles[8].isAI() && gTiles[5].isAI() && gTiles[2].isAI()) {
            isMiniMaxAIWin = true;
        } else if (gTiles[8].isAI() && gTiles[7].isAI() && gTiles[6].isAI()) {
            isMiniMaxAIWin = true;
        } else if (gTiles[2].isAI() && gTiles[4].isAI() && gTiles[6].isAI()) {
            isMiniMaxAIWin = true;
        } else if (gTiles[1].isAI() && gTiles[4].isAI() && gTiles[7].isAI()) {
            isMiniMaxAIWin = true;
        } else if (gTiles[3].isAI() && gTiles[4].isAI() && gTiles[5].isAI()) {
            isMiniMaxAIWin = true;
        } else if (gTiles[0].isPlayer() && gTiles[1].isPlayer() && gTiles[2].isPlayer()) {
            isMiniMaxPlayerWin = true;
        } else if (gTiles[0].isPlayer() && gTiles[4].isPlayer() && gTiles[8].isPlayer()) {
            isMiniMaxPlayerWin = true;
        } else if (gTiles[0].isPlayer() && gTiles[3].isPlayer() && gTiles[6].isPlayer()) {
            isMiniMaxPlayerWin = true;
        } else if (gTiles[8].isPlayer() && gTiles[5].isPlayer() && gTiles[2].isPlayer()) {
            isMiniMaxPlayerWin = true;
        } else if (gTiles[8].isPlayer() && gTiles[7].isPlayer() && gTiles[6].isPlayer()) {
            isMiniMaxPlayerWin = true;
        } else if (gTiles[2].isPlayer() && gTiles[4].isPlayer() && gTiles[6].isPlayer()) {
            isMiniMaxPlayerWin = true;
        } else if (gTiles[1].isPlayer() && gTiles[4].isPlayer() && gTiles[7].isPlayer()) {
            isMiniMaxPlayerWin = true;
        } else if (gTiles[3].isPlayer() && gTiles[4].isPlayer() && gTiles[5].isPlayer()) {
            isMiniMaxPlayerWin = true;
        }
        if (++cTurn == 10 && !isMiniMaxPlayerWin && !isMiniMaxAIWin) {
            isMiniMaxDraw = true;
        }
        if (isMiniMaxAIWin) {
            bestScore = totalFreeTiles;
        } else if (isMiniMaxPlayerWin) {
            bestScore = totalFreeTiles * -1;
        } else if (isMiniMaxDraw) {
            bestScore = 0;
        } else {
            bestScore = isMaximizing ? 99 : -99;
            for (i = 0; i < gTiles.length; ++i) {
                int miniMaxScore;
                if (gTiles[i].isAI() || gTiles[i].isPlayer() || this.difficulty != 2 && simRound >= 2) continue;
                if (isMaximizing) {
                    miniMaxScore = this.miniMax(false, gTiles, i, cTurn, simRound + 1);
                    if (miniMaxScore > bestScore) continue;
                    bestScore = miniMaxScore;
                    continue;
                }
                miniMaxScore = this.miniMax(true, gTiles, i, cTurn, simRound + 1);
                if (miniMaxScore < bestScore) continue;
                bestScore = miniMaxScore;
            }
        }
        return bestScore;
    }

    private void playerTurn(int tile) {
        this.gameTiles[tile].select(true);
        this.evaluateTurn();
        if (!(this.isPlayerWin || this.isAIWin || this.isDraw)) {
            this.aiTurn();
        }
    }

    private void setDifficulty(int i) {
        this.difficulty = i;
        this.root.getChildren().remove(1);
        this.root.getChildren().add(this.mainHBox);
    }

    public static void main(String[] args) {
        TicTacToe.launch(new String[0]);
    }
}

